package io.k8s.api.networking.v1beta1

/* IngressBackend describes all endpoints for a given service and port. */
import io.circe._
import io.circe.generic.semiauto._

case class IngressBackend(
  /* Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified. */
  resource: Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  /* Specifies the name of the referenced service. */
  serviceName: Option[String] = None,
  /* Specifies the port of the referenced service. */
  servicePort: Option[com.goyeau.kubernetes.client.IntOrString] = None
)

object IngressBackend {
  implicit lazy val encoder: Encoder.AsObject[IngressBackend] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressBackend] = deriveDecoder
}
