package io.k8s.api.batch.v1

/* JobCondition describes current state of a job. */
import io.circe._
import io.circe.generic.semiauto._

case class JobCondition(
  /* Type of job condition, Complete or Failed. */
  `type`: String,
  /* Status of the condition, one of True, False, Unknown. */
  status: String,
  /* Last time the condition was checked. */
  lastProbeTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Last time the condition transit from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Human readable message indicating details about last transition. */
  message: Option[String] = None,
  /* (brief) reason for the condition's last transition. */
  reason: Option[String] = None
)

object JobCondition {
  implicit lazy val encoder: Encoder.AsObject[JobCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[JobCondition] = deriveDecoder
}
