package io.k8s.api.batch.v1

/* JobStatus represents the current state of a Job. */
import io.circe._
import io.circe.generic.semiauto._

case class JobStatus(
  /* The number of actively running pods. */
  active: Option[Int] = None,
  /* Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. */
  completionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* The latest available observations of an object's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ */
  conditions: Option[Seq[io.k8s.api.batch.v1.JobCondition]] = None,
  /* The number of pods which reached phase Failed. */
  failed: Option[Int] = None,
  /* Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. */
  startTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* The number of pods which reached phase Succeeded. */
  succeeded: Option[Int] = None
)

object JobStatus {
  implicit lazy val encoder: Encoder.AsObject[JobStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[JobStatus] = deriveDecoder
}
