package io.k8s.api.core.v1

/* LimitRangeSpec defines a min/max usage limit for resources that match on kind. */
import io.circe._
import io.circe.generic.semiauto._

case class LimitRangeSpec(
  /* Limits is the list of LimitRangeItem objects that are enforced. */
  limits: Seq[io.k8s.api.core.v1.LimitRangeItem]
)

object LimitRangeSpec {
  implicit lazy val encoder: Encoder.AsObject[LimitRangeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[LimitRangeSpec] = deriveDecoder
}
