package io.k8s.api.core.v1

/* LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point. */
import io.circe._
import io.circe.generic.semiauto._

case class LoadBalancerIngress(
  /* Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers) */
  hostname: Option[String] = None,
  /* IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers) */
  ip: Option[String] = None
)

object LoadBalancerIngress {
  implicit lazy val encoder: Encoder.AsObject[LoadBalancerIngress] = deriveEncoder
  implicit lazy val decoder: Decoder[LoadBalancerIngress] = deriveDecoder
}
