package io.k8s.api.core.v1

/* LoadBalancerStatus represents the status of a load-balancer. */
import io.circe._
import io.circe.generic.semiauto._

case class LoadBalancerStatus(
  /* Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points. */
  ingress: Option[Seq[io.k8s.api.core.v1.LoadBalancerIngress]] = None
)

object LoadBalancerStatus {
  implicit lazy val encoder: Encoder.AsObject[LoadBalancerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[LoadBalancerStatus] = deriveDecoder
}
