package io.k8s.api.core.v1

/* LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace. */
import io.circe._
import io.circe.generic.semiauto._

case class LocalObjectReference(
  /* Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names */
  name: Option[String] = None
)

object LocalObjectReference {
  implicit lazy val encoder: Encoder.AsObject[LocalObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[LocalObjectReference] = deriveDecoder
}
