package io.k8s.apimachinery.pkg.apis.meta.v1

/* ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to. */
import io.circe._
import io.circe.generic.semiauto._

case class ManagedFieldsEntry(
  /* APIVersion defines the version of this resource that this field set applies to. The format is "group/version" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted. */
  apiVersion: Option[String] = None,
  /* FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: "FieldsV1" */
  fieldsType: Option[String] = None,
  /* FieldsV1 holds the first JSON version format as described in the "FieldsV1" type. */
  fieldsV1: Option[io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1] = None,
  /* Manager is an identifier of the workflow managing these fields. */
  manager: Option[String] = None,
  /* Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'. */
  operation: Option[String] = None,
  /* Time is timestamp of when these fields were set. It should always be empty if Operation is 'Apply' */
  time: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object ManagedFieldsEntry {
  implicit lazy val encoder: Encoder.AsObject[ManagedFieldsEntry] = deriveEncoder
  implicit lazy val decoder: Decoder[ManagedFieldsEntry] = deriveDecoder
}
