package io.k8s.api.core.v1

/* NamespaceSpec describes the attributes on a Namespace. */
import io.circe._
import io.circe.generic.semiauto._

case class NamespaceSpec(
  /* Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/ */
  finalizers: Option[Seq[String]] = None
)

object NamespaceSpec {
  implicit lazy val encoder: Encoder.AsObject[NamespaceSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[NamespaceSpec] = deriveDecoder
}
