package io.k8s.api.core.v1

/* NodeDaemonEndpoints lists ports opened by daemons running on the Node. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeDaemonEndpoints(
  /* Endpoint on which Kubelet is listening. */
  kubeletEndpoint: Option[io.k8s.api.core.v1.DaemonEndpoint] = None
)

object NodeDaemonEndpoints {
  implicit lazy val encoder: Encoder.AsObject[NodeDaemonEndpoints] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeDaemonEndpoints] = deriveDecoder
}
