package io.k8s.api.core.v1

/* NodeStatus is information about the current status of a node. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeStatus(
  /* List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See http://pr.k8s.io/79391 for an example. */
  addresses: Option[Seq[io.k8s.api.core.v1.NodeAddress]] = None,
  /* Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity. */
  allocatable: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity */
  capacity: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition */
  conditions: Option[Seq[io.k8s.api.core.v1.NodeCondition]] = None,
  /* Status of the config assigned to the node via the dynamic Kubelet config feature. */
  config: Option[io.k8s.api.core.v1.NodeConfigStatus] = None,
  /* Endpoints of daemons running on the Node. */
  daemonEndpoints: Option[io.k8s.api.core.v1.NodeDaemonEndpoints] = None,
  /* List of container images on this node */
  images: Option[Seq[io.k8s.api.core.v1.ContainerImage]] = None,
  /* Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info */
  nodeInfo: Option[io.k8s.api.core.v1.NodeSystemInfo] = None,
  /* NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated. */
  phase: Option[String] = None,
  /* List of volumes that are attached to the node. */
  volumesAttached: Option[Seq[io.k8s.api.core.v1.AttachedVolume]] = None,
  /* List of attachable volumes in use (mounted) by the node. */
  volumesInUse: Option[Seq[String]] = None
)

object NodeStatus {
  implicit lazy val encoder: Encoder.AsObject[NodeStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeStatus] = deriveDecoder
}
