package io.k8s.api.core.v1

/* NodeSystemInfo is a set of ids/uuids to uniquely identify the node. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeSystemInfo(
  /* MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html */
  machineID: String,
  /* SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html */
  systemUUID: String,
  /* Boot ID reported by the node. */
  bootID: String,
  /* Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64). */
  kernelVersion: String,
  /* OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)). */
  osImage: String,
  /* ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0). */
  containerRuntimeVersion: String,
  /* Kubelet Version reported by the node. */
  kubeletVersion: String,
  /* KubeProxy Version reported by the node. */
  kubeProxyVersion: String,
  /* The Operating System reported by the node */
  operatingSystem: String,
  /* The Architecture reported by the node */
  architecture: String
)

object NodeSystemInfo {
  implicit lazy val encoder: Encoder.AsObject[NodeSystemInfo] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeSystemInfo] = deriveDecoder
}
