package io.k8s.apimachinery.pkg.apis.meta.v1

/* OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field. */
import io.circe._
import io.circe.generic.semiauto._

case class OwnerReference(
  /* API version of the referent. */
  apiVersion: String,
  /* Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: String,
  /* Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names */
  name: String,
  /* UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids */
  uid: String,
  /* If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. */
  blockOwnerDeletion: Option[Boolean] = None,
  /* If true, this reference points to the managing controller. */
  controller: Option[Boolean] = None
)

object OwnerReference {
  implicit lazy val encoder: Encoder.AsObject[OwnerReference] = deriveEncoder
  implicit lazy val decoder: Decoder[OwnerReference] = deriveDecoder
}
