package io.k8s.api.core.v1

/* PersistentVolumeClaim is a user's request for and claim to a persistent volume */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeClaim(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims */
  spec: Option[io.k8s.api.core.v1.PersistentVolumeClaimSpec] = None,
  /* Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims */
  status: Option[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = None
)

object PersistentVolumeClaim {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaim] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaim] = deriveDecoder
}
