package io.k8s.api.core.v1

/* PersistentVolumeClaimCondition contails details about state of pvc */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeClaimCondition(
  `type`: String,
  status: String,
  /* Last time we probed the condition. */
  lastProbeTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Last time the condition transitioned from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Human-readable message indicating details about last transition. */
  message: Option[String] = None,
  /* Unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "ResizeStarted" that means the underlying persistent volume is being resized. */
  reason: Option[String] = None
)

object PersistentVolumeClaimCondition {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimCondition] = deriveDecoder
}
