package io.k8s.api.core.v1

/* PersistentVolumeClaimStatus is the current status of a persistent volume claim. */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeClaimStatus(
  /* AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1 */
  accessModes: Option[Seq[String]] = None,
  /* Represents the actual resources of the underlying volume. */
  capacity: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'. */
  conditions: Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]] = None,
  /* Phase represents the current phase of PersistentVolumeClaim. */
  phase: Option[String] = None
)

object PersistentVolumeClaimStatus {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimStatus] = deriveDecoder
}
