package io.k8s.api.core.v1

/* PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system). */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeClaimVolumeSource(
  /* ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims */
  claimName: String,
  /* Will force the ReadOnly setting in VolumeMounts. Default false. */
  readOnly: Option[Boolean] = None
)

object PersistentVolumeClaimVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimVolumeSource] = deriveDecoder
}
