package io.k8s.api.core.v1

/* PersistentVolumeList is a list of PersistentVolume items. */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeList(
  /* List of persistent volumes. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes */
  items: Seq[io.k8s.api.core.v1.PersistentVolume],
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object PersistentVolumeList {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeList] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeList] = deriveDecoder
}
