package io.k8s.api.core.v1

/* PersistentVolumeSpec is the specification of a persistent volume. */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeSpec(
  /* AccessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes */
  accessModes: Option[Seq[String]] = None,
  /* AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore */
  awsElasticBlockStore: Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  /* AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. */
  azureDisk: Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  /* AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
  azureFile: Option[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] = None,
  /* A description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity */
  capacity: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* CephFS represents a Ceph FS mount on the host that shares a pod's lifetime */
  cephfs: Option[io.k8s.api.core.v1.CephFSPersistentVolumeSource] = None,
  /* Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md */
  cinder: Option[io.k8s.api.core.v1.CinderPersistentVolumeSource] = None,
  /* ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding */
  claimRef: Option[io.k8s.api.core.v1.ObjectReference] = None,
  /* CSI represents storage that is handled by an external CSI driver (Beta feature). */
  csi: Option[io.k8s.api.core.v1.CSIPersistentVolumeSource] = None,
  /* FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod. */
  fc: Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  /* FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. */
  flexVolume: Option[io.k8s.api.core.v1.FlexPersistentVolumeSource] = None,
  /* Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running */
  flocker: Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  /* GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk */
  gcePersistentDisk: Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  /* Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md */
  glusterfs: Option[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] = None,
  /* HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath */
  hostPath: Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  /* ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. */
  iscsi: Option[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] = None,
  /* Local represents directly-attached storage with node affinity */
  local: Option[io.k8s.api.core.v1.LocalVolumeSource] = None,
  /* A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options */
  mountOptions: Option[Seq[String]] = None,
  /* NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs */
  nfs: Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  /* NodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume. */
  nodeAffinity: Option[io.k8s.api.core.v1.VolumeNodeAffinity] = None,
  /* What happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming */
  persistentVolumeReclaimPolicy: Option[String] = None,
  /* PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine */
  photonPersistentDisk: Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  /* PortworxVolume represents a portworx volume attached and mounted on kubelets host machine */
  portworxVolume: Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  /* Quobyte represents a Quobyte mount on the host that shares a pod's lifetime */
  quobyte: Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  /* RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md */
  rbd: Option[io.k8s.api.core.v1.RBDPersistentVolumeSource] = None,
  /* ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes. */
  scaleIO: Option[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] = None,
  /* Name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass. */
  storageClassName: Option[String] = None,
  /* StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md */
  storageos: Option[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] = None,
  /* volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec. */
  volumeMode: Option[String] = None,
  /* VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine */
  vsphereVolume: Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None
)

object PersistentVolumeSpec {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeSpec] = deriveDecoder
}
