package io.k8s.api.core.v1

/* Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts. */
import io.circe._
import io.circe.generic.semiauto._

case class Pod(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  spec: Option[io.k8s.api.core.v1.PodSpec] = None,
  /* Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  status: Option[io.k8s.api.core.v1.PodStatus] = None
)

object Pod {
  implicit lazy val encoder: Encoder.AsObject[Pod] = deriveEncoder
  implicit lazy val decoder: Decoder[Pod] = deriveDecoder
}
