package io.k8s.api.core.v1

/* PodDNSConfigOption defines DNS resolver options of a pod. */
import io.circe._
import io.circe.generic.semiauto._

case class PodDNSConfigOption(
  /* Required. */
  name: Option[String] = None,
  value: Option[String] = None
)

object PodDNSConfigOption {
  implicit lazy val encoder: Encoder.AsObject[PodDNSConfigOption] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDNSConfigOption] = deriveDecoder
}
