package io.k8s.api.policy.v1beta1

/* PodDisruptionBudgetSpec is a description of a PodDisruptionBudget. */
import io.circe._
import io.circe.generic.semiauto._

case class PodDisruptionBudgetSpec(
  /* An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable". */
  maxUnavailable: Option[com.goyeau.kubernetes.client.IntOrString] = None,
  /* An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%". */
  minAvailable: Option[com.goyeau.kubernetes.client.IntOrString] = None,
  /* Label query over pods whose evictions are managed by the disruption budget. */
  selector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
)

object PodDisruptionBudgetSpec {
  implicit lazy val encoder: Encoder.AsObject[PodDisruptionBudgetSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDisruptionBudgetSpec] = deriveDecoder
}
