package io.k8s.api.core.v1

/* IP address information for entries in the (plural) PodIPs field. Each entry includes:
   IP: An IP address allocated to the pod. Routable at least within the cluster. */
import io.circe._
import io.circe.generic.semiauto._

case class PodIP(
  /* ip is an IP address (IPv4 or IPv6) assigned to the pod */
  ip: Option[String] = None
)

object PodIP {
  implicit lazy val encoder: Encoder.AsObject[PodIP] = deriveEncoder
  implicit lazy val decoder: Decoder[PodIP] = deriveDecoder
}
