package io.k8s.api.core.v1

/* PortworxVolumeSource represents a Portworx volume resource. */
import io.circe._
import io.circe.generic.semiauto._

case class PortworxVolumeSource(
  /* VolumeID uniquely identifies a Portworx volume */
  volumeID: String,
  /* FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified. */
  fsType: Option[String] = None,
  /* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None
)

object PortworxVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[PortworxVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[PortworxVolumeSource] = deriveDecoder
}
