package io.k8s.api.core.v1

/* Represents a projected volume source */
import io.circe._
import io.circe.generic.semiauto._

case class ProjectedVolumeSource(
  /* list of volume projections */
  sources: Seq[io.k8s.api.core.v1.VolumeProjection],
  /* Mode bits to use on created files by default. Must be a value between 0 and 0777. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. */
  defaultMode: Option[Int] = None
)

object ProjectedVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[ProjectedVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ProjectedVolumeSource] = deriveDecoder
}
