package io.k8s.api.core.v1

/* Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class RBDPersistentVolumeSource(
  /* A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  monitors: Seq[String],
  /* The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  image: String,
  /* Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd */
  fsType: Option[String] = None,
  /* Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  keyring: Option[String] = None,
  /* The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  pool: Option[String] = None,
  /* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  readOnly: Option[Boolean] = None,
  /* SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  secretRef: Option[io.k8s.api.core.v1.SecretReference] = None,
  /* The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it */
  user: Option[String] = None
)

object RBDPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[RBDPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[RBDPersistentVolumeSource] = deriveDecoder
}
