package io.k8s.api.apps.v1

/* ReplicaSetStatus represents the current status of a ReplicaSet. */
import io.circe._
import io.circe.generic.semiauto._

case class ReplicaSetStatus(
  /* Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller */
  replicas: Int,
  /* The number of available replicas (ready for at least minReadySeconds) for this replica set. */
  availableReplicas: Option[Int] = None,
  /* Represents the latest available observations of a replica set's current state. */
  conditions: Option[Seq[io.k8s.api.apps.v1.ReplicaSetCondition]] = None,
  /* The number of pods that have labels matching the labels of the pod template of the replicaset. */
  fullyLabeledReplicas: Option[Int] = None,
  /* ObservedGeneration reflects the generation of the most recently observed ReplicaSet. */
  observedGeneration: Option[Long] = None,
  /* The number of ready replicas for this replica set. */
  readyReplicas: Option[Int] = None
)

object ReplicaSetStatus {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSetStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSetStatus] = deriveDecoder
}
