package io.k8s.api.core.v1

/* ResourceFieldSelector represents container resources (cpu, memory) and their output format */
import io.circe._
import io.circe.generic.semiauto._

case class ResourceFieldSelector(
  /* Required: resource to select */
  resource: String,
  /* Container name: required for volumes, optional for env vars */
  containerName: Option[String] = None,
  /* Specifies the output format of the exposed resources, defaults to "1" */
  divisor: Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
)

object ResourceFieldSelector {
  implicit lazy val encoder: Encoder.AsObject[ResourceFieldSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceFieldSelector] = deriveDecoder
}
