package io.k8s.api.core.v1

/* ResourceQuota sets aggregate quota restrictions enforced per namespace */
import io.circe._
import io.circe.generic.semiauto._

case class ResourceQuota(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  spec: Option[io.k8s.api.core.v1.ResourceQuotaSpec] = None,
  /* Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  status: Option[io.k8s.api.core.v1.ResourceQuotaStatus] = None
)

object ResourceQuota {
  implicit lazy val encoder: Encoder.AsObject[ResourceQuota] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceQuota] = deriveDecoder
}
