package io.k8s.api.core.v1

/* ResourceQuotaSpec defines the desired hard limits to enforce for Quota. */
import io.circe._
import io.circe.generic.semiauto._

case class ResourceQuotaSpec(
  /* hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/ */
  hard: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched. */
  scopeSelector: Option[io.k8s.api.core.v1.ScopeSelector] = None,
  /* A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects. */
  scopes: Option[Seq[String]] = None
)

object ResourceQuotaSpec {
  implicit lazy val encoder: Encoder.AsObject[ResourceQuotaSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[ResourceQuotaSpec] = deriveDecoder
}
