package io.k8s.api.rbac.v1

/* RoleRef contains information that points to the role being used */
import io.circe._
import io.circe.generic.semiauto._

case class RoleRef(
  /* APIGroup is the group for the resource being referenced */
  apiGroup: String,
  /* Kind is the type of resource being referenced */
  kind: String,
  /* Name is the name of resource being referenced */
  name: String
)

object RoleRef {
  implicit lazy val encoder: Encoder.AsObject[RoleRef] = deriveEncoder
  implicit lazy val decoder: Decoder[RoleRef] = deriveDecoder
}
