package io.k8s.api.apps.v1

/* RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType. */
import io.circe._
import io.circe.generic.semiauto._

case class RollingUpdateStatefulSetStrategy(
  /* Partition indicates the ordinal at which the StatefulSet should be partitioned. Default value is 0. */
  partition: Option[Int] = None
)

object RollingUpdateStatefulSetStrategy {
  implicit lazy val encoder: Encoder.AsObject[RollingUpdateStatefulSetStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[RollingUpdateStatefulSetStrategy] = deriveDecoder
}
