package io.k8s.api.policy.v1beta1

/* RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy. */
import io.circe._
import io.circe.generic.semiauto._

case class RunAsUserStrategyOptions(
  /* rule is the strategy that will dictate the allowable RunAsUser values that may be set. */
  rule: String,
  /* ranges are the allowed ranges of uids that may be used. If you would like to force a single uid then supply a single range with the same start and end. Required for MustRunAs. */
  ranges: Option[Seq[io.k8s.api.policy.v1beta1.IDRange]] = None
)

object RunAsUserStrategyOptions {
  implicit lazy val encoder: Encoder.AsObject[RunAsUserStrategyOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[RunAsUserStrategyOptions] = deriveDecoder
}
