package io.k8s.api.core.v1

/* SELinuxOptions are the labels to be applied to the container */
import io.circe._
import io.circe.generic.semiauto._

case class SELinuxOptions(
  /* Level is SELinux level label that applies to the container. */
  level: Option[String] = None,
  /* Role is a SELinux role label that applies to the container. */
  role: Option[String] = None,
  /* Type is a SELinux type label that applies to the container. */
  `type`: Option[String] = None,
  /* User is a SELinux user label that applies to the container. */
  user: Option[String] = None
)

object SELinuxOptions {
  implicit lazy val encoder: Encoder.AsObject[SELinuxOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[SELinuxOptions] = deriveDecoder
}
