package io.k8s.api.autoscaling.v1

/* ScaleSpec describes the attributes of a scale subresource. */
import io.circe._
import io.circe.generic.semiauto._

case class ScaleSpec(
  /* desired number of instances for the scaled object. */
  replicas: Option[Int] = None
)

object ScaleSpec {
  implicit lazy val encoder: Encoder.AsObject[ScaleSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[ScaleSpec] = deriveDecoder
}
