package io.k8s.api.core.v1

/* A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values. */
import io.circe._
import io.circe.generic.semiauto._

case class ScopedResourceSelectorRequirement(
  /* The name of the scope that the selector applies to. */
  scopeName: String,
  /* Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. */
  operator: String,
  /* An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch. */
  values: Option[Seq[String]] = None
)

object ScopedResourceSelectorRequirement {
  implicit lazy val encoder: Encoder.AsObject[ScopedResourceSelectorRequirement] = deriveEncoder
  implicit lazy val decoder: Decoder[ScopedResourceSelectorRequirement] = deriveDecoder
}
