package io.k8s.api.core.v1

/* SecretEnvSource selects a Secret to populate the environment variables with.

The contents of the target Secret's Data field will represent the key-value pairs as environment variables. */
import io.circe._
import io.circe.generic.semiauto._

case class SecretEnvSource(
  /* Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names */
  name: Option[String] = None,
  /* Specify whether the Secret must be defined */
  optional: Option[Boolean] = None
)

object SecretEnvSource {
  implicit lazy val encoder: Encoder.AsObject[SecretEnvSource] = deriveEncoder
  implicit lazy val decoder: Decoder[SecretEnvSource] = deriveDecoder
}
