package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* ServiceReference holds a reference to Service.legacy.k8s.io */
import io.circe._
import io.circe.generic.semiauto._

case class ServiceReference(
  /* namespace is the namespace of the service. Required */
  namespace: String,
  /* name is the name of the service. Required */
  name: String,
  /* path is an optional URL path at which the webhook will be contacted. */
  path: Option[String] = None,
  /* port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility. */
  port: Option[Int] = None
)

object ServiceReference {
  implicit lazy val encoder: Encoder.AsObject[ServiceReference] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceReference] = deriveDecoder
}
