package io.k8s.api.core.v1

/* ServiceStatus represents the current status of a service. */
import io.circe._
import io.circe.generic.semiauto._

case class ServiceStatus(
  /* LoadBalancer contains the current status of the load-balancer, if one is present. */
  loadBalancer: Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
)

object ServiceStatus {
  implicit lazy val encoder: Encoder.AsObject[ServiceStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ServiceStatus] = deriveDecoder
}
