package io.k8s.api.apps.v1

/* StatefulSet represents a set of pods with consistent identities. Identities are defined as:
 - Network: A single stable DNS and hostname.
 - Storage: As many VolumeClaims as requested.
The StatefulSet guarantees that a given network identity will always map to the same storage identity. */
import io.circe._
import io.circe.generic.semiauto._

case class StatefulSet(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Spec defines the desired identities of pods in this set. */
  spec: Option[io.k8s.api.apps.v1.StatefulSetSpec] = None,
  /* Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time. */
  status: Option[io.k8s.api.apps.v1.StatefulSetStatus] = None
)

object StatefulSet {
  implicit lazy val encoder: Encoder.AsObject[StatefulSet] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSet] = deriveDecoder
}
