package io.k8s.api.apps.v1

/* StatefulSetCondition describes the state of a statefulset at a certain point. */
import io.circe._
import io.circe.generic.semiauto._

case class StatefulSetCondition(
  /* Type of statefulset condition. */
  `type`: String,
  /* Status of the condition, one of True, False, Unknown. */
  status: String,
  /* Last time the condition transitioned from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* A human readable message indicating details about the transition. */
  message: Option[String] = None,
  /* The reason for the condition's last transition. */
  reason: Option[String] = None
)

object StatefulSetCondition {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetCondition] = deriveDecoder
}
