package io.k8s.api.apps.v1

/* StatefulSetList is a collection of StatefulSets. */
import io.circe._
import io.circe.generic.semiauto._

case class StatefulSetList(
  items: Seq[io.k8s.api.apps.v1.StatefulSet],
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object StatefulSetList {
  implicit lazy val encoder: Encoder.AsObject[StatefulSetList] = deriveEncoder
  implicit lazy val decoder: Decoder[StatefulSetList] = deriveDecoder
}
