package io.k8s.apimachinery.pkg.apis.meta.v1

/* Status is a return value for calls that don't return other objects. */
import io.circe._
import io.circe.generic.semiauto._

case class Status(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Suggested HTTP return code for this status, 0 if not set. */
  code: Option[Int] = None,
  /* Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type. */
  details: Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* A human-readable description of the status of this operation. */
  message: Option[String] = None,
  /* Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None,
  /* A machine-readable description of why this operation is in the "Failure" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it. */
  reason: Option[String] = None,
  /* Status of the operation. One of: "Success" or "Failure". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  status: Option[String] = None
)

object Status {
  implicit lazy val encoder: Encoder.AsObject[Status] = deriveEncoder
  implicit lazy val decoder: Decoder[Status] = deriveDecoder
}
