package io.k8s.apimachinery.pkg.apis.meta.v1

/* StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered. */
import io.circe._
import io.circe.generic.semiauto._

case class StatusCause(
  /* The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.
  
  Examples:
    "name" - the field "name" on the current resource
    "items[0].name" - the field "name" on the first array entry in "items" */
  field: Option[String] = None,
  /* A human-readable description of the cause of the error.  This field may be presented as-is to a reader. */
  message: Option[String] = None,
  /* A machine-readable description of the cause of the error. If this value is empty there is no information available. */
  reason: Option[String] = None
)

object StatusCause {
  implicit lazy val encoder: Encoder.AsObject[StatusCause] = deriveEncoder
  implicit lazy val decoder: Decoder[StatusCause] = deriveDecoder
}
