package io.k8s.apimachinery.pkg.apis.meta.v1

/* StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined. */
import io.circe._
import io.circe.generic.semiauto._

case class StatusDetails(
  /* The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes. */
  causes: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause]] = None,
  /* The group attribute of the resource associated with the status StatusReason. */
  group: Option[String] = None,
  /* The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described). */
  name: Option[String] = None,
  /* If specified, the time in seconds before the operation should be retried. Some errors may indicate the client must take an alternate action - for those errors this field may indicate how long to wait before taking the alternate action. */
  retryAfterSeconds: Option[Int] = None,
  /* UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids */
  uid: Option[String] = None
)

object StatusDetails {
  implicit lazy val encoder: Encoder.AsObject[StatusDetails] = deriveEncoder
  implicit lazy val decoder: Decoder[StatusDetails] = deriveDecoder
}
