package io.k8s.api.core.v1

/* Represents a StorageOS persistent volume resource. */
import io.circe._
import io.circe.generic.semiauto._

case class StorageOSVolumeSource(
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. */
  fsType: Option[String] = None,
  /* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None,
  /* SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted. */
  secretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  /* VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace. */
  volumeName: Option[String] = None,
  /* VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created. */
  volumeNamespace: Option[String] = None
)

object StorageOSVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[StorageOSVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[StorageOSVolumeSource] = deriveDecoder
}
