package io.k8s.api.core.v1

/* Sysctl defines a kernel parameter to be set */
import io.circe._
import io.circe.generic.semiauto._

case class Sysctl(
  /* Name of a property to set */
  name: String,
  /* Value of a property to set */
  value: String
)

object Sysctl {
  implicit lazy val encoder: Encoder.AsObject[Sysctl] = deriveEncoder
  implicit lazy val decoder: Decoder[Sysctl] = deriveDecoder
}
