package io.k8s.api.core.v1

/* TCPSocketAction describes an action based on opening a socket */
import io.circe._
import io.circe.generic.semiauto._

case class TCPSocketAction(
  /* Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. */
  port: com.goyeau.kubernetes.client.IntOrString,
  /* Optional: Host name to connect to, defaults to the pod IP. */
  host: Option[String] = None
)

object TCPSocketAction {
  implicit lazy val encoder: Encoder.AsObject[TCPSocketAction] = deriveEncoder
  implicit lazy val decoder: Decoder[TCPSocketAction] = deriveDecoder
}
