package io.k8s.api.core.v1

/* The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint. */
import io.circe._
import io.circe.generic.semiauto._

case class Taint(
  /* Required. The taint key to be applied to a node. */
  key: String,
  /* Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute. */
  effect: String,
  /* TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints. */
  timeAdded: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* The taint value corresponding to the taint key. */
  value: Option[String] = None
)

object Taint {
  implicit lazy val encoder: Encoder.AsObject[Taint] = deriveEncoder
  implicit lazy val decoder: Decoder[Taint] = deriveDecoder
}
