package io.k8s.api.core.v1

/* A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future. */
import io.circe._
import io.circe.generic.semiauto._

case class TopologySelectorLabelRequirement(
  /* The label key that the selector applies to. */
  key: String,
  /* An array of string values. One value must match the label to be selected. Each entry in Values is ORed. */
  values: Seq[String]
)

object TopologySelectorLabelRequirement {
  implicit lazy val encoder: Encoder.AsObject[TopologySelectorLabelRequirement] = deriveEncoder
  implicit lazy val decoder: Decoder[TopologySelectorLabelRequirement] = deriveDecoder
}
